<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="tableStyle.css?v=<?php echo time(); ?>">
    <title>SELL</title>
    <style>
        #main {
            width: 100%;
            display: flex;
            flex-direction: row;
            margin: 0px;
        }

        #divleft {
            width: 10%;
            display: flex;
            flex-direction: column;
        }

        #divright {
            width: 85%;
            background-color: rgb(255, 247, 227);
            padding: 20px;
        }

        #divleft button {
            width: 80%;
            height: 50px;
            margin-bottom: 20px;
            border-radius: 4px;
            border: none;
            cursor: pointer;
        }

        #divleft button:hover {
            background-color: #b3cce6;
        }

        #divright button {
            margin: 10px 10px 10px 0px;
            padding: 8px 14px;
            background-color: #3399ff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        #searchInput,
        #SupplInput,
        #resetBtn,
        #searchidapranq {
            height: 40px;
            font-size: 20px;
        }

        #fchange {
            display: none;
        }
    </style>
</head>

<body>
    <div id="main">
        <div id="divleft">
            <button type="submit" onclick="OpenMyPage(1)">Ապրանքներ </button>
            <button type="submit" onclick="order()">Մուտք</button>
            <button type="submit" onclick="elq()">Ելք պահեստից</button>
            <button type="submit" onclick="suppl()">Մատակարարներ</button>
            <button type="submit" onclick="OpenMyPage(5)">Տեղեկատուներ</button>

        </div>
        <div id="divright">
            <div hidden id="order"> մուտք
                <div id="tblorder"></div>
            </div>
            <div hidden id="elq">Ելք պահեստից</div>
            <div hidden id="suppl">Մատակարարներ
                <div id="tblsuppl"></div>
            </div>
        </div>
    </div>

    <script src="tableclass.js"></script>
    <script>
        function suppl() {
            document.getElementById("apranq").hidden = true;
            document.getElementById("order").hidden = true;
            document.getElementById("elq").hidden = true;
            document.getElementById("suppl").hidden = false;

            const contdiv = document.getElementById("tblsuppl");
            contdiv.innerHTML = '';

            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const result = JSON.parse(xhttp.responseText);

                    // ստեղծում է աղյուսակը
                    const newtable = new Table(
                        "#tblsuppl",
                        ["text", "text", "number", "number", "number", "number", "number", "checkbox", "text", "number"],
                        [{ idsupplier: "ԻԴՄ" }, { supplier: "Մատակարար" }, { partq0: "Սկզբնական պարտք" }],
                        result
                    );

                }
            };

            xhttp.open("GET", "suppl_data.php?", true);
            xhttp.send();
        }
        function fchange() {
            const row = document.getElementsByClassName('active-row');
            console.log(row[0]);
            document.getElementById('fchange').style.display = "block";
        }
    </script>
</body>

</html>

<script>
    async function OpenMyPage(PunktNumber) {
        let div = document.getElementById("divright");
        let url = '';
        let scriptUrl = '';
        let shouldCallGetData = false;

        switch (PunktNumber) {
            case 1:
                url = 'apranqner/index.html'; 
                scriptUrl = 'apranqner/script.js';
                shouldCallGetData = true;
                break;
            default:
                return;
        }

        // 1. Загружаем HTML
        const html = await fetch(url).then(res => res.text());

        // 2. Вставляем в div
        div.innerHTML = html;

        // 3. Проверяем, подключён ли скрипт
        const isLoaded = Array.from(document.scripts).some(s => s.src.includes(scriptUrl));

        if (!isLoaded) {
            // 4. Загружаем скрипт вручную и ждем
            await loadScript(scriptUrl);
        }
    }

    // Вспомогательная функция загрузки внешнего JS
    function loadScript(src) {
        return new Promise((resolve, reject) => {
            const script = document.createElement('script');
            script.src = src + '?v=' + Date.now(); // cache-busting
            script.onload = resolve;
            script.onerror = () => reject(new Error(`Ошибка загрузки ${src}`));
            document.body.appendChild(script);
        });
    }
</script>